//
//  TodoItemRow.swift
//  Do It
//
//  Created by Jim Dovey on 9/5/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import SwiftUI

struct TodoItemRow: View {
    @State var item: TodoItem
    @EnvironmentObject var data: DataCenter
    
    var body: some View {
        HStack {
            Button(action: {
                self.item.complete.toggle()
                let idx = self.data.todoItems.firstIndex { $0.id == self.item.id }!
                self.data.todoItems[idx] = self.item
            }) {
                Image(systemName: item.complete
                    ? "largecircle.fill.circle"
                    : "circle")
                    .imageScale(.large)
                    .foregroundColor(.accentColor)
            }
            .padding(.trailing, 6)
            .buttonStyle(HighPriorityButtonStyle())

            VStack(alignment: .leading) {
                Text(item.title)
                    .font(.headline)
                    .foregroundColor(.primary)
                    .padding(.bottom, 2)

                if item.date != nil {
                    Text("\(item.date!, formatter: Formatters.optionalTime(in: item.date!))")
                        .font(.caption)
                        .foregroundColor(.secondary)
                }
            }
        }
    }
}

struct TodoItemRow_Previews: PreviewProvider {
    static var previews: some View {
        TodoItemRow(item: defaultTodoItems[0])
            .padding()
            .previewLayout(.sizeThatFits)
            .environmentObject(DataCenter())
    }
}
